(
    -- MultiTile Texture: FULL IMPLEMENTATION
	-- 
	-- GetUUID() is the same as the one in CompositeTexturemap.ms, 
	-- means it reuses same graph definition of CompositeMap.
	-- In GetMaps(), replace the semantics with MultiTile methods,
	-- and set proper init values in GetParams()
	
	struct AMGData 
    (
        fn GetUUID mtl context =
        (
            "5d210056-f52c-4c17-8cba-0fef8f265f26"
        ),

        fn GetMaps mtl context =
        (
            local res = #()	
            
            local layer = mtl.tileCount() - (context / 256)
            local newContext = mod context 256

            local subLayer = mtl.getTileTexmap layer 

            if (subLayer != undefined) do
            (
				if (newContext == 1) then
				(
					-- Bump mode
					append res #("fg",           subLayer,  "normalPerturb", newContext) 
				)
				else
				(
					-- Regular mode, also attach alpha
					append res #("fg",           subLayer,  "result", newContext) 
					append res #("alpha",        subLayer,  "alpha",  newContext) 
				)
            )

            -- Recurseively append yourself
            if (layer > 1) do
            (
                append res #("bg",           mtl, "result", context + 256) 
				append res #("bgalpha",      mtl, "alpha", context + 256) 
            )

            res
        ),

        fn GetParams mtl context = 
        (
            local res = #()	

            append res #( "weight",   1.0)  
            append res #( "mode",	  0)  
            append res #( "mask",	  1.0)            -- Default
			append res #( "alpha",	  0.0)            -- Default
            append res #( "bg",	      (color 0 0 0))  -- Default
            append res #( "fg",	      (color 0 0 0))  -- Default

            res
        )
    )

    AMGData()
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAtALWBtIfwwIlG3uWMTf1ZvbGr11rSJuSw
-- Y9rzL8xyqB7zI8Q37ZjbxjXFnZ5IpFIl9x9kBFonB6L+ymaplZMq9T0zaxrHjvlg
-- 849HNVzMv0k1dyvujOSgq9hb7lla7iUnpD08yLnOYP6yv1ueGur+33AyYMPk1OhQ
-- 9zhmXPPxH1REL8tDS34VabMYCiNoiiVDZx0H8yIdoNFC43S1FnaXHwVGbCeE6WeL
-- pJHp5pVHEU+jumdvudyhbCotrTy+n7+WEIGZpkPqj4NCDF2DnZfC3iTtUXvyeXFs
-- pyNSA0RgqTB6UVAigsgcrm5WEEZHaw1JBm+OTFluuGBubdtOrAo/
-- -----END-SIGNATURE-----